% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{get.go}
\alias{get.go}
\title{Get Gene Ontology Annotation}
\usage{
get.go(id, filter = TRUE, format = 'dataframe', silent = FALSE)
}
\arguments{
\item{id}{the UniProt identifier of the protein of interest.}

\item{filter}{logical, if TRUE a reduced number of terms, selected on the basis of astringent criteria (see details) is returned.}

\item{format}{string indicating the output's format. It should be either 'dataframe' or 'string'. The 'string' format may be convenient when subsequent GO terms enrichment analysis is intended.}

\item{silent}{logical, if FALSE print details of the reading process.}
}
\value{
Returns a dataframe (by default) with GO IDs linked to the protein of interest, as well as additional information related to these GO ids. A string with the GO ids can be obtained as output if indicated by means of the argument 'format'.
}
\description{
Gets the gene ontology annotations for a given protein.
}
\details{
Since some well-characterized proteins can have many GO annotations, it may be convenient to filter the shown GO terms. When filter is set to TRUE, the annotated terms displayed are those provided by the corresponding UniProtKB entry, which are selected based on their granularity and evidence code quality (with manual annotations preferred over automatic predictions). Annotations that have been made to isoform identifiers, or use any of the GO annotation qualifiers (NOT, contributes_to, colocalizes_with) are also removed.
}
\examples{
\dontrun{get.go('P01009')}
}
\references{
Rhee et al. (2008) Nature Reviews Genetics 9:509–515.
}
\seealso{
search.go, term.go(), bg.go(), hdfisher.go(), gorilla(), net.go()
}
\author{
Juan Carlos Aledo
}
