% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accdpx.R
\name{mkdssp}
\alias{mkdssp}
\title{Compute DSSP File Using an In-House Version of the DSSP Software}
\usage{
mkdssp(pdb, method = 'ptm', exefile = "dssp")
}
\arguments{
\item{pdb}{is either a 4-character identifier of the PDB structure, or the path to a pdb file.}

\item{method}{a character string specifying the desired method to get the dssp dataframe; it should be one of 'ptm' or 'bio3d'.}

\item{exefile}{file path to the DSSP executable on your system (i.e. how is DSSP invoked).}
}
\value{
Returns either a dataframe containing the information extracted from the dssp file (method ptm), or a list with that information (method bio3d).
}
\description{
Computes the DSSP file using an in-house version of the DSSP software.
}
\details{
The structure of the output data depends on the method chosen, but it will always contain the DSSP-related data.
}
\examples{
\dontrun{mkdssp('3cwm', method = 'ptm')}
}
\references{
Touw et al (2015) Nucl. Ac. Res. 43(Database issue): D364-D368 (PMID: 25352545).
}
\seealso{
download.dssp(), parse.dssp(), compute.dssp() and acc.dssp()
}
\author{
Juan Carlos Aledo
}
