% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddG.R
\name{foldx.stab}
\alias{foldx.stab}
\title{Compute Folding Free Energy (DG)}
\usage{
foldx.stab(pdb, pH = 7, I = 0.05)
}
\arguments{
\item{pdb}{the 4-letter identifier of a PDB structure or the path to a PDB file.}

\item{pH}{a numeric value between 0 and 14.}

\item{I}{a value indicating the molar ionic strength.}
}
\value{
The function computes and returns the DG (kcal/mol) of the folding process of the requested protein.
}
\description{
Computes changes in the Gibbs free energy of the folding process of a protein.
}
\details{
This function implements the FoldX's command 'Stability'
}
\examples{
\dontrun{foldx.stab('5zok')}
}
\references{
Schymkowitz et al (2005) Nucl. Ac. Res. 33:W382-W388.
}
\seealso{
foldx.assembly()
}
\author{
Juan Carlos Aledo
}
