% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accdpx.R
\name{get.area}
\alias{get.area}
\title{Atomic Solvation Energies.}
\usage{
get.area(pdb, keepfiles = FALSE)
}
\arguments{
\item{pdb}{is either a PDB id, or the path to a pdb file.}

\item{keepfiles}{logical, if TRUE the dataframe will be saved in the working directory and we will keep the getarea txt file.}
}
\value{
This function returns a dataframe containing the requested information.
}
\description{
Computes online surface energies using the Getarea server.
}
\details{
If the option keepfiles is set as TRUE, then txt and Rda files are saved in the working directory.
}
\examples{
\dontrun{get.area('3cwm')}
}
\references{
Fraczkiewicz, R. and Braun, W. (1998) J. Comp. Chem., 19, 319-333.
}
\seealso{
compute.dssp(), atom.dpx(), res.dpx(), acc.dssp(), str.part()
}
\author{
Juan Carlos Aledo
}
