% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{net.go}
\alias{net.go}
\title{Gene Ontology Network}
\usage{
net.go(data, threshold = 0.2, silent = FALSE)
}
\arguments{
\item{data}{either a vector containing the UniProt IDs (vertices) or the path to the txt or rda file containing them.}

\item{threshold}{threshold value of the Jaccard index above which two proteins are considered to be linked.}

\item{silent}{logical, if FALSE print details of the running process.}
}
\value{
Returns a list containing (i) the dataframe corresponding to the computed Jaccard matrix, (ii) the adjacency matrix, (iii) a vector containing the vertices, and (iv) a matrix describing the edges of the network.
}
\description{
Explores the relationship among proteins from a given set.
}
\details{
This function first searches the GO terms for each vertex and then computes the Jaccard index for each protein pair, based on their GO terms. Afterwards, an adjacency matrix is computed, where two proteins are linked if their Jaccard index is greater than the selected threshold.
}
\examples{
\dontrun{net.go(path2data = "./GOvivo.txt")}
}
\references{
Aledo & Aledo (2020) Antioxidants 9(10), 987.

Rhee et al. (2008) Nature Reviews Genetics 9:509–515.
}
\seealso{
search.go(), term.go(), get.go(), bg.go(), gorilla()
}
\author{
Pablo Aledo & Juan Carlos Aledo
}
