% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_test.R
\name{e_test}
\alias{e_test}
\title{Poisson E-test}
\usage{
e_test(k1, k2, n1 = 1, n2 = 1, d = 0, eps = 1e-20, silent = FALSE)
}
\arguments{
\item{k1}{scaler Poisson count}

\item{k2}{scaler Poisson count}

\item{n1}{scaler divisor for k1 (e.g. rate per unit time or per area), default 1}

\item{n2}{scaler divisor for k2 (e.g. rate per unit time or per area), default 1}

\item{d}{scaler amends the null test by a constant amount, default 0}

\item{eps}{scaler where to terminate sum in testing larger deviations, default 1e-20}

\item{silent}{boolean if TRUE, does not print error messages}
}
\value{
A scaler p-value. Will return -1 if inputs don't make sense and print an error message, e.g. \code{e_test(0,0)} is undefined and will return a -1.
}
\description{
Tests differences in two Poisson means or rates.
}
\details{
This e-test tests the differences in two Poisson counts or rates. The null is more formally:

\deqn{k_1/n_1 = k_2/n_2 + d}{k1/n1 = k2/n2 + d}

Note, I would be wary using the test for Poisson counts over 100 (the tail approximation in the sums will have issues, as the PMF is so spread out). (It is also the case with \emph{very} large k's, e.g. \code{e_test(4000,4000)} my function could run out of memory.) In that case may use the n arguments to make it a rate per some unit time (which can change the p-value, although for smaller counts/rates should be very close).
}
\examples{
# For small N, changes in rates should result in same p-value minus floating point differences
e_test(3,0)
e_test(3,0,2,2)

# Not defined
e_test(0,0) #returns -1 and prints warning

# The same rates
e_test(20,10,4,2)
e_test(10,5,2,1) #not quite the same

# Order of counts/rates should not matter
e_test(6,2) #second example from Krishnamoorthy article
e_test(2,6) #when d=0, can switch arguments and get the same p-value

# These are not the same however, due to how the variance estimates work
e_test(3,2)
e_test(3,1,d=1)
}
\references{
Krishnamoorthy, K., & Thomson, J. (2004). A more powerful test for comparing two Poisson means. \emph{Journal of Statistical Planning and Inference}, 119(1), 23-35.
}
\seealso{
\code{\link[=wdd]{wdd()}}, can use that function for a normal based approximation to the difference in Poisson means as well as pre/post designs
}
