% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hex.R
\name{hex_dim}
\alias{hex_dim}
\title{Get dimensions of hexagon given area}
\usage{
hex_dim(area)
}
\arguments{
\item{area}{scaler}
}
\value{
a vector with two elements, first element is the height (vertex to vertex), the second element is the width (side to side)
}
\description{
Get dimensions of hexagon given area
}
\details{
For use with ggplot and \code{geom_hex} binwidth arguments, which expects arguments in width/height. I want hexagons in maps to be a specific area. See \href{https://andrewpwheeler.com/2019/08/07/making-a-hexbin-map-in-ggplot/}{this blog post} for a specific use case with ggplot.
}
\examples{
area_check <- 1000
wh <- hex_dim(area_check^2)   #e.g. a square kilometer if spatial units are in meters
area <- hex_area(wh[1]/2)       #inverse operation
all.equal(area_check,sqrt(area))
wi <- hex_wd(wh[1])
all.equal(wh[2],wi)

}
\seealso{
\code{\link[=hex_wd]{hex_wd()}} for estimating the width given the height
\code{\link[=hex_area]{hex_area()}} for estimating the area given side length
}
