% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{vor_sp}
\alias{vor_sp}
\title{Voronoi tesselation from input points}
\usage{
vor_sp(outline, feat)
}
\arguments{
\item{outline}{object that can be coerced to a spatstat window via \code{as.owin} (so SpatialPolygonDataFrame, SpatialPolygon, owin)}

\item{feat}{A SpatialPointsDataFrame object (if duplicate X/Y coordinates will get errors)}
}
\value{
A SpatialPolygonsDataFrame object, including the dataframe for all the info in the orignal \code{feat@data} dataframe.
}
\description{
Given an outline and feature points, calculates Voronoi areas
}
\details{
Outline should be a single polygon area. Uses spatstats \code{dirichlet} and window to compute the Voronoi tesselation.
Will generate errors if feat has duplicate X/Y points. Useful to create areas for other functions,
such as \code{dcount_xy()} or \code{count_xy()}. Common spatial unit of analysis used in crime research when using points (e.g. intersections
and street midpoints).
}
\examples{
\donttest{
library(sp) # for sample/coordinates
data(nyc_bor)
nyc_buff <- raster::buffer(nyc_bor,50000)
po <- sp::spsample(nyc_buff,20,'hexagonal')
po$id <- 1:dim(coordinates(po))[1] # turns into SpatialDataFrame
vo <- vor_sp(nyc_buff,po)
plot(vo)
plot(nyc_buff,border='RED',lwd=3, add=TRUE)
}

}
\references{
Wheeler, A. P. (2018). The effect of 311 calls for service on crime in DC at microplaces. \emph{Crime & Delinquency}, 64(14), 1882-1903.

Wheeler, A. P. (2019). Quantifying the local and spatial effects of alcohol outlets on crime. \emph{Crime & Delinquency}, 65(6), 845-871.
}
