% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fare-estimate.R
\name{fare_estimate}
\alias{fare_estimate}
\title{Calculate a fare estimate between zones}
\usage{
fare_estimate(
  min_zone,
  max_zone,
  journey_touch_on = NULL,
  journey_touch_off = NULL,
  journey_in_free_tram_zone = FALSE,
  travelled_route_types = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{min_zone}{Integer. Minimum zone travelled through.}

\item{max_zone}{Integer. Maximum zone travelled through.}

\item{journey_touch_on, journey_touch_off}{POSIXct or Character. Optionally
filter results to a journey time. Values to both must be provided.
Characters are automatically converted to datetimes, and are assumed to be
given as Melbourne time.}

\item{journey_in_free_tram_zone}{Boolean. Defaults to \code{FALSE}.}

\item{travelled_route_types}{Integer or character vector. Optionally filter
by a vector of route types. A route type can be provided either as a
non-negative integer code, or as a character: "Tram", "Train", "Bus",
"Vline" or "Night Bus". Character inputs are not case-sensitive. Use the
\code{route_types} function to extract a vector of all route types.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A data frame consisting of one row for each \code{passenger_type}, and the
following columns: \itemize{
\item \code{min_zone}
\item \code{max_zone}
\item \code{unique_zones}
\item \code{early_bird}
\item \code{free_tram_zone}
\item \code{weekend_journey}
\item \code{passenger_type}
\item \code{fare_2_hour_peak}
\item \code{fare_2_hour_off_peak}
\item \code{fare_daily_peak}
\item \code{fare_daily_off_peak}
\item \code{pass_7_days}
\item \code{pass_28_to_69_day_per_day}
\item \code{pass_70_plus_day_per_day}
\item \code{weekend_cap}
\item \code{holiday_cap}
}
}
\description{
Retrieve fare information for a journey through the given zones. Also
supports journey touch on and off times, to accommodate for discounts.
}
\examples{
\dontrun{
fare_estimate(min_zone = 1, max_zone = 2)

fare_estimate(min_zone = 1, max_zone = 1, journey_in_free_tram_zone = TRUE)

fare_estimate(
  min_zone = 1,
  max_zone = 2,
  travelled_route_types = c("Train", "Tram")
)

fare_estimate(
  min_zone = 1,
  max_zone = 2,
  journey_touch_on = "2020-06-21 07:31:00",
  journey_touch_off = "2020-06-21 08:45:00"
 )
}

}
