% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disruptions.R
\name{disruption_information}
\alias{disruption_information}
\title{Information on a particular disruption}
\usage{
disruption_information(
  disruption_id,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{disruption_id}{Integer.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble with the following columns: \itemize{
\item \code{disruption_mode}
\item \code{disruption_mode_description}
\item \code{disruption_id}
\item \code{title}
\item \code{url}
\item \code{description}
\item \code{disruption_status}
\item \code{disruption_type}
\item \code{published_on}
\item \code{last_updated}
\item \code{from_date}
\item \code{to_date}
\item \code{routes}
\item \code{stops}
\item \code{colour}
\item \code{display_on_board}
\item \code{display_status}
}
}
\description{
This function can be used when the integer disruption ID is already known.
This can be searched for with either \code{disruptions},
\code{disruptions_on_route}, or \code{disruptions_at_stop} functions.
}
\examples{
\dontrun{
disruption_information(206639)
}

}
