% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{pseudo_r2}
\alias{pseudo_r2}
\title{Pseudo R2 (logistic regression)
\code{pseudo_r2} Calculates R2 analogues (pseudo R2) of logistic regression.}
\usage{
pseudo_r2(model)
}
\arguments{
\item{model}{A logistic regression model.}
}
\value{
A data frame with the calculated pseudo R2 values.
}
\description{
Pseudo R2 (logistic regression)
\code{pseudo_r2} Calculates R2 analogues (pseudo R2) of logistic regression.
}
\details{
\code{pseudo_r2} calculates three pseudo R2 of logistic regression models: 1) Nagelkerke, @0 Cox and Snell, 3) Hosmer and Lemeshow.
}
\examples{
model_oncho <- glm(mf ~ area, data = Oncho, binomial)
glm_coef(model_oncho, labels = c("Constant", "Area (rainforest/savannah)"))
pseudo_r2(model_oncho)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
