% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{strip_error}
\alias{strip_error}
\title{Strip plots with error bars.}
\usage{
strip_error(
  object = NULL,
  formula = NULL,
  data = NULL,
  pch = 20,
  size = 1,
  alpha = 0.7,
  col = "indianred3",
  ...
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: \code{y ~ x} or \code{y ~ x|z} where \code{y} is a
numerical variable and both \code{x} and \code{z} are factors.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{pch}{Point character passed to \code{\link{gf_point}} or \code{\link{gf_jitter}}.}

\item{size}{Size of the symbol (\code{pch}) for representing data values.}

\item{alpha}{Opacity of the symbol (0 = invisible, 1 = opaque).}

\item{col}{A colour or formula used for mapping colour.}

\item{...}{Additional information passed to \code{\link{gf_jitter}} or \code{\link{gf_point}}.}
}
\description{
\code{strip_error} constructs strip plots with error bars showing 95% bootstrapped
confidence intervals around mean values.
}
\examples{
data(energy, package="ISwR")
require(sjlabelled)
energy = energy \%>\%
  var_labels(
    expend = 'Energy expenditure (MJ/day)',
    stature = 'Stature'
  )

energy \%>\%
  strip_error(expend ~ stature, col = 'red') \%>\%
  axis_labs()

t.test(expend ~ stature, data = energy)

## Adding an horizontal line to show significant difference:
energy \%>\%
  strip_error(expend ~ stature, col = 'red') \%>\%
  axis_labs() \%>\%
  gf_star(1, 13, 2, 13.2, 13.4, "**")

data(birthwt, package = "MASS")
require(dplyr)
birthwt <- birthwt \%>\%
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
    Race = factor(race > 1, labels = c("White", "Non-white"))
  ) \%>\%
  var_labels(
    bwt = 'Birth weight (g)',
    smoke = 'Smoking status'
 )

birthwt \%>\%
  strip_error(bwt ~ smoke|Race, col = 'darksalmon') \%>\%
  axis_labs()

birthwt \%>\%
  strip_error(bwt ~ smoke, col = ~ Race) \%>\%
  gf_refine(ggsci::scale_color_jama()) \%>\%
  axis_labs()

birthwt \%>\%
  strip_error(bwt ~ smoke, pch = ~ Race, col = ~ Race) \%>\%
  gf_refine(ggsci::scale_color_jama()) \%>\%
  axis_labs()

birthwt \%>\%
  strip_error(bwt ~ smoke|Race) \%>\%
  axis_labs()
}
