% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{hist_norm}
\alias{hist_norm}
\title{Histogram with Normal density curve.}
\usage{
hist_norm(
  object = NULL,
  formula = NULL,
  data = NULL,
  binwidth = NULL,
  fill = "indianred3",
  color = "black",
  alpha = 0.7,
  ...
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: \code{ ~ y} or \code{~ y|x} where \code{y} is a numerical variable and \code{x} is a factor.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{binwidth}{The width of the histogram bins.}

\item{fill}{Colour to fill the bars of the histogram.}

\item{color}{Colour used for the border of the bars.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{...}{Further arguments passed to \link{gf_dhistogram}.}
}
\description{
\code{hist_norm} constructs histograms and adds corresponding Normal density curve.
}
\examples{
require(dplyr)
require(sjlabelled)
data(birthwt, package = "MASS")
birthwt <- birthwt \%>\%
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
    Race = factor(race > 1, labels = c("White", "Non-white"))
  ) \%>\%
  var_labels(
    bwt = 'Birth weight (g)',
    smoke = 'Smoking status'
 )

birthwt \%>\%
  hist_norm(~ bwt, alpha = 0.7, bins = 20, fill = 'cadetblue') \%>\%
  axis_labs()

birthwt \%>\%
  hist_norm(~ bwt|smoke, alpha = 0.7, bins = 20, fill = 'cadetblue') \%>\%
  axis_labs()
}
