% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Thall}
\alias{Thall}
\title{RCT on the treatment of epilepsy.}
\format{A tibble with 59 rows and 8 variables:
\describe{
\item{id}{Subject ID.}
\item{treat}{Treatment, factor with levels "Control" and "Prograbide".}
\item{base}{Number of seizures at baseline.}
\item{age}{Age in years at baseline.}
\item{y1}{Number of seizures at year one follow-up.}
\item{y2}{Number of seizures at year two follow-up.}
\item{y3}{Number of seizures at year three follow-up.}
\item{y4}{Number of seizures at year four follow-up.}
}}
\source{
Thall, PF and Vail, SC (1990) Some covariance models for longitudinal count data with over-dispersion.
Biometrics, 46: 657-671.

Stukel, TA (1993) Comparison of methods for the analysis of longitudinal data. Statistics Med 12:
1339-1351.

Shoukri, MM and Chaudhary, MA (2007) Analysis of correlated data with SAS and R. Third Edition.
Chapman & Hall/CRC.
}
\usage{
Thall
}
\description{
Randomised control trial of an antiepilectic drug (prograbide), in which the number of seizures of 59 patients
at baseline and other four follow-up visits were recorded.
}
\examples{
data(Thall)

c1 <- cbind(Thall[, c(1:5)], count = Thall$y1)[, c(1:4, 6)]
c2 <- cbind(Thall[, c(1:4, 6)], count = Thall$y2)[, c(1:4, 6)]
c3 <- cbind(Thall[, c(1:4, 7)], count = Thall$y3)[, c(1:4, 6)]
c4 <- cbind(Thall[, c(1:4, 8)], count = Thall$y3)[, c(1:4, 6)]
epilepsy <- rbind(c1, c2, c3, c4)

require(lme4)
model_glmer <- glmer(count ~ treat + base + I(age - mean(age, na.rm = TRUE)) +
                 (1|id), data = epilepsy, family = poisson)
glm_coef(model_glmer, labels = c("Treatment (Prograbide/Control)",
                               "Baseline count", "Age (years)"))
}
\keyword{datasets}
