% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{gen_bst_df}
\alias{gen_bst_df}
\title{Generate a data frame with estimate and bootstrap CIs.}
\usage{
gen_bst_df(object = NULL, formula = NULL, data = NULL, stat = "mean", ...)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: \code{y ~ x} or \code{y ~ x|z} where \code{y} is a
numerical variable and both \code{x} and \code{z} are factors.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{stat}{Statistic used for \link{bst}.}

\item{...}{Passes optional arguments to \link{bst}.}
}
\value{
A data frame with the confidence intervals by level.
}
\description{
\code{gen_bst_df} is a function called that generates a data frame with
confidence intervals of a continuous variable by levels of one or two categorical ones (factors).
}
\examples{
data(kfm, package = "ISwR")
require(sjlabelled, quietly = TRUE)
kfm <- kfm \%>\%
  var_labels(
    dl.milk = "Breast-milk intake (dl/day)",
    sex = "Sex",
    weight = "Child weight (kg)",
    ml.suppl = "Milk substitute (ml/day)",
    mat.weight = "Maternal weight (kg)",
    mat.height = "Maternal height (cm)"
  )

kfm \%>\%
  gen_bst_df(dl.milk ~ sex)

data(birthwt, package = "MASS")
require(dplyr, quietly = TRUE)
birthwt <- mutate(birthwt,
  smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
  Race = factor(race > 1, labels = c("White", "Non-white"))
)

birthwt <- birthwt \%>\%
  var_labels(
    bwt = "Birth weight (g)",
    smoke = "Smoking status"
  )

gen_bst_df(bwt ~ smoke | Race, data = birthwt)
}
