% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{multiple}
\alias{multiple}
\title{Multiple comparisons with plot.}
\usage{
multiple(
  model,
  formula,
  adjust = "mvt",
  type = "response",
  reverse = TRUE,
  level = 0.95,
  digits = 2,
  ...
)
}
\arguments{
\item{model}{A fitted model supported by \code{emmeans}, such as the result of a call to \code{aov}, \code{lm}, \code{glm}, etc.}

\item{formula}{A formula with shape: \code{~ y} or \code{~ y|x} (for interactions). Where \code{y} is the term of the model on which comparisons are made and \code{x} is a term interacting with \code{y}.}

\item{adjust}{Method to adjust CIs and p-values (see details).}

\item{type}{Type of prediction  (matching "linear.predictor", "link", or "response").}

\item{reverse}{Logical argument. Determines the direction of comparisons.}

\item{level}{Confidence interval significance level.}

\item{digits}{Number of digits for rounding (default = 2).}

\item{...}{Further arguments passed to \code{\link[emmeans]{emmeans}}.}
}
\value{
A list with objects: \code{df} A data frame with adjusted p-values, \code{fig_ci} a plot with estimates and adjusted confidence intervals and \code{fig_pval} a plot comparing adjusted p-values.
}
\description{
\code{multiple} displays results from post-doc analysis and constructs corresponding plot.
}
\details{
The default adjusting method is "mvt" which uses the multivariate t distribution.
Other options are: "bonferroni", "holm", "hochberg", "tukey" and "none". The default option for argument \code{reverse} is to make reverse comparisons, i.e., against the reference level matching comparisons from \code{lm} and \code{glm}.
}
\examples{
data(birthwt, package = "MASS")
birthwt$race <- factor(birthwt$race, labels = c("White", "African American", "Other"))

model_1 <- aov(bwt ~ race, data = birthwt)
multiple(model_1, ~race)$df

multiple(model_1, ~race)$fig_ci \%>\%
  gf_labs(y = "Race", x = "Difference in birth weights (g)")

multiple(model_1, ~race)$fig_pval \%>\%
  gf_labs(y = "Race")
}
\seealso{
\code{\link[emmeans]{emmeans}}, \code{\link[emmeans]{pwpp}}.
}
