% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pmids_from_one_search.R
\name{get_pmids_from_one_search}
\alias{get_pmids_from_one_search}
\title{Returns a list of PMID's for a provided Pubmed search}
\usage{
get_pmids_from_one_search(query, api_key)
}
\arguments{
\item{query}{A Pubmed search query}

\item{api_key}{A valid Pubmed API key}
}
\value{
A named list with 3 elements:

\if{html}{\out{<div class="sourceCode">}}\preformatted{`$pubmed_search_success`, which is TRUE in the case that the
provided query was searched successfully on Pubmed and FALSE
otherwise.

`$n_results`, the number of results for the search as reported
by Pubmed

`$pmids`, a list of PMID's corresponding to the Pubmed search
results for the query provided
}\if{html}{\out{</div>}}
}
\description{
Returns a list of PMID's for a provided Pubmed search
}
\examples{

\dontrun{
## Read in API key
ak <- readLines("api_key.txt")

## Download PMID's for search query
results <- get_pmids_from_one_search("Carlisle B[Author]", ak)

## Extract first result
results$pmids[1]
}
}
