% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.anova}
\alias{style.apa.anova}
\title{Formats a Analysis of Variance Result}
\usage{
style.apa.anova(x, effect = 1)
}
\arguments{
\item{x}{a list. First item must be a Anova table from
\code{\link[stats]{anova}}. All other list items will be ignored.}

\item{effect}{a numeric, specifying the effect or model comparison that
should be printed.  Please note that the default value of 1 is not
appropriate for model comparisons.}
}
\value{
character vector with a formatted character vector.
}
\description{
This style functions takes a Anova table from \code{\link[stats]{anova}}
and transforms it into a formatted character vector. This function checks
for model comparisons.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
pprint(anova(lm(weight ~ Diet, data = ChickWeight)),
       format = "anova")
pprint(anova(lm(weight ~ Diet, data = ChickWeight),
             lm(weight ~ Diet + Time, data = ChickWeight)),
       format = "anova",
       effect = 2)
}
\seealso{
\code{\link[stats]{anova}}

Other APA.style.functions: \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

