% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{pull.pubprint}
\alias{pull.pubprint}
\title{Pulls an item from a pubprint object}
\usage{
\method{pull}{pubprint}(x, item = 1, remove = pp_opts$get("removeItems"),
  ...)
}
\arguments{
\item{x}{a pubprint object}

\item{item}{the item to pull. If item is numeric, pipe and if it is a
character, named memory is chosen.}

\item{remove}{either a logical, \code{"pipe"} or \code{"memory"}. If
\code{remove} is \code{TRUE}, every returned item is removed from pipe or
memory. If it is \code{"pipe"} (or \code{"memory"}), only accessed pipe (or
memory) items will be removed.}

\item{...}{further arguments passed to \code{\link{pprint}} or the internal
style functions.}
}
\value{
The updated object.
}
\description{
\code{pull.pubprint} is used to pull an item from the pipe or the named
memory of a pubprint object.
}
\details{
No further details.
}
\examples{
ppo <- pubprint()
push(ppo) <- t.test(1:100, 2:101)
push(ppo, add = TRUE) <- .8123 # add d value to last pipe item
push(ppo, item = "i1") <- t.test(1:30, 2:31)

pull(ppo)
pull(ppo, item = "i1")
pull(ppo, item = "i1", remove = TRUE) # removes item as well

}
\seealso{
See \code{\link{pull}} for the generic function,
\code{\link{push<-}} to put items to pipe or named memory.
}

