% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{ped_sort_i}
\alias{ped_sort_i}
\alias{sort_step}
\title{Sorting steps}
\usage{
sort_step(p, id, dam, sire, t, S, G, t_G)
}
\arguments{
\item{p}{Pedigree to sort (used as template)}

\item{id}{A string naming the column with individual identities. It will be renamed to its default value 'id'.}

\item{dam}{A string naming the column with maternal identities. It will be renamed to its default value 'dam'.}

\item{sire}{A string naming the column with paternal identities. It will be renamed to its default value 'sire'.}

\item{t}{Template for the new sorted pedigree}

\item{S}{Vector of assumed parent individuals}

\item{G}{Vector of generation numbers (0 identifies the youngest)}

\item{t_G}{Vector G for the new sorted pedigree}
}
\value{
No return value. Will print an error message if checking fail.

Filled template for the sorted pedigree. Once recursion ends, it returns the sorted pedigree
}
\description{
Recursive function that computes steps for sorting algorithm described by Zhang et al (2009).
}
\references{
\itemize{
  \item{Zhang Z, Li C, Todhunter RJ, Lust G, Goonewardene L, Wang Z. 2009. An algorithm to sort complex pedigrees chronologically without birthdates. J Anim Vet Adv. 8 (1): 177-182.}
}
}
\seealso{
\code{\link{ped_sort}}
}
