% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{reproductive_value}
\alias{reproductive_value}
\title{Reproductive value}
\usage{
reproductive_value(
  ped,
  reference,
  name_to,
  target = NULL,
  enable_correction = TRUE
)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{reference}{A string naming a column indicating whether individuals belong to the reference population or not. Column must be boolean or coercible to boolean type.}

\item{name_to}{A string naming the new output column.}

\item{target}{A string naming a column indicating whether individuals belong to the target population or not. Column must be boolean or coercible to boolean type. By default, all descendants of the reference population are used.}

\item{enable_correction}{Correct reproductive values.}
}
\value{
The input dataframe, plus an additional column with reproductive values for the reference and target populations assumed.
}
\description{
Computes the reproductive value
}
\references{
Hunter DC et al. 2019. Pedigree-based estimation of reproductive value. Journal of Heredity 110 (4): 433-444
}
