% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rows.R
\name{by_slice}
\alias{by_slice}
\title{Apply a function to slices of a data frame}
\usage{
by_slice(.d, ..f, ..., .labels = TRUE)
}
\arguments{
\item{.d}{A sliced data frame.}

\item{..f}{A function to apply to each slice. If \code{..f} does
not return a data frame or an atomic vector, a list-column is
created under the name \code{.out}. If it returns a data frame, it
should have the same number of rows within groups and the same
number of columns between groups.}

\item{...}{Further arguments passed to \code{..f}.}

\item{.labels}{If \code{TRUE}, the returned data frame is prepended
with the labels of the slices (the columns in \code{.d} used to
define the slices). They are recycled to match the output size in
each slice if necessary.}
}
\value{
A data frame.
}
\description{
\code{by_slice()} applies `..f` on each group of a data
frame. Groups should be set with \code{slice_rows()} or
\code{\link[dplyr]{group_by}()}.
}
\details{
\code{by_slice()} provide equivalent functionality to dplyr's
\code{\link[dplyr]{do}()} function. In combination with
\code{map()}, \code{by_slice()} is equivalent to
\code{\link[dplyr]{summarise_each}()} and
\code{\link[dplyr]{mutate_each}()}. The distinction between
mutating and summarising operations is not as important as in dplyr
because we do not act on the columns separately. When we map a
function to each column, the only constraint is that the number of
returned rows match inside each slice.
}
\examples{
# Here we fit a regression model inside each slice defined by the
# unique values of the column "cyl". The fitted models are returned
# in a list-column.
mtcars \%>\%
  slice_rows("cyl") \%>\%
  by_slice(partial(lm, mpg ~ disp))

# by_slice() is especially useful in combination with map().
# Mutating and summarising operations can be used indistinctly.

# Mutating operation:
mtcars \%>\%
  slice_rows(c("cyl", "am")) \%>\%
  by_slice(map, ~ .x / sd(.x))

# Summarising operation:
mtcars \%>\%
  slice_rows(c("cyl", "am")) \%>\%
  by_slice(map, mean)

# If you don't need the slicing variables as identifiers, switch
# .labels to FALSE:
mtcars \%>\%
  slice_rows("cyl") \%>\%
  by_slice(partial(lm, mpg ~ disp), .labels = FALSE) \%>\%
  flatten() \%>\%
  map(coef)
}
\seealso{
\code{\link{by_row}()}, \code{\link{slice_rows}()}
}

