% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep}
\alias{compact}
\alias{discard}
\alias{keep}
\title{Keep or discard elements using a predicate function.}
\usage{
keep(.x, .p, ...)

discard(.x, .p, ...)

compact(.x, .p = identity)
}
\arguments{
\item{.x}{A list or vector.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{...}{Additional arguments passed on to \code{.p}.}
}
\description{
\code{keep} and \code{discard} are opposites. \code{compact} is a handy
wrapper that removes all elements that are \code{NULL}.
}
\details{
These are usually called \code{select} or \code{filter} and \code{reject} or
\code{drop}, but those names are already taken. \code{keep} is similar to
\code{\link{Filter}} but the argument order is more convenient, and the
evaluation of \code{.f} is stricter.
}
\examples{
rep(10, 10) \%>\%
  map(sample, 5) \%>\%
  keep(function(x) mean(x) > 6)

# Or use a formula
rep(10, 10) \%>\%
  map(sample, 5) \%>\%
  keep(~ mean(.x) > 6)

# Using a string instead of a function will select all list elements
# where that subelement is TRUE
x <- rerun(5, a = rbernoulli(1), b = sample(10))
x
x \%>\% keep("a")
x \%>\% discard("a")
}

