% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_object_S3_methods.R
\name{heatmap_pvEBayes}
\alias{heatmap_pvEBayes}
\title{Generate a heatmap plot visualizing posterior probabilities for selected
drugs and adverse events}
\usage{
heatmap_pvEBayes(
  x,
  num_top_AEs = 10,
  num_top_drugs = 8,
  specified_AEs = NULL,
  specified_drugs = NULL,
  cutoff_signal = NULL
)
}
\arguments{
\item{x}{a \code{pvEBayes} object, which is the output of the function
\link{pvEBayes} or \link{pvEBayes_tune}.}

\item{num_top_AEs}{number of most significant AEs appearing in the plot. Default to
10.}

\item{num_top_drugs}{number of most significant drugs appearing in the plot. Default
to 7.}

\item{specified_AEs}{a vector of AE names that are specified to appear in the plot. If
a vector of AEs is given, argument num_top_AEs will be ignored.}

\item{specified_drugs}{a vector of drug names that are specified to appear in the plot.
If a vector of drugs is given, argument num_top_drugs will be ignored.}

\item{cutoff_signal}{numeric. Threshold for signal detection. An AE-drug
combination is classified as a detected signal if its 5th posterior
percentile exceeds this threshold.}
}
\value{
a ggplot2 object.
}
\description{
This function generates a heatmap to visualize the posterior probabilities
of being a signal for selected AEs and drugs.
}
\examples{

fit <- pvEBayes(
  contin_table = statin2025_44, model = "general-gamma",
  alpha = 0.3, n_posterior_draws = 1000
)


heatmap_pvEBayes(
  x = fit,
  cutoff = 1.001
)

}
