% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win1bg1.R
\name{win1bg1}
\alias{win1bg1}
\title{Compute power for a One Factor Within Subjects and One Factor Between ANOVA with up to two by four levels (within).
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
win1bg1(
  m1.1,
  m2.1,
  m3.1 = NA,
  m4.1 = NA,
  m1.2,
  m2.2,
  m3.2 = NA,
  m4.2 = NA,
  s1.1 = NA,
  s2.1 = NA,
  s3.1 = NA,
  s4.1 = NA,
  s1.2 = NA,
  s2.2 = NA,
  s3.2 = NA,
  s4.2 = NA,
  r1.2_1 = NULL,
  r1.3_1 = NULL,
  r1.4_1 = NULL,
  r2.3_1 = NULL,
  r2.4_1 = NULL,
  r3.4_1 = NULL,
  r1.2_2 = NULL,
  r1.3_2 = NULL,
  r1.4_2 = NULL,
  r2.3_2 = NULL,
  r2.4_2 = NULL,
  r3.4_2 = NULL,
  r = NULL,
  s = NULL,
  n,
  alpha = 0.05
)
}
\arguments{
\item{m1.1}{Mean of first level Within Factor, 1st level Between Factor}

\item{m2.1}{Mean of second level Within Factor, 1st level Between Factor}

\item{m3.1}{Mean of third level Within Factor, 1st level Between Factor}

\item{m4.1}{Mean of fourth level Within Factor, 1st level Between Factor}

\item{m1.2}{Mean of first level Within Factor, 2nd level Between Factor}

\item{m2.2}{Mean of second level Within Factor, 2nd level Between Factor}

\item{m3.2}{Mean of third level Within Factor, 2nd level Between Factor}

\item{m4.2}{Mean of fourth level Within Factor, 2nd level Between Factor}

\item{s1.1}{Standard deviation of first level Within Factor, 1st level Between Factor}

\item{s2.1}{Standard deviation of second level Within Factor, 1st level Between Factor}

\item{s3.1}{Standard deviation of third level Within Factor, 1st level Between Factor}

\item{s4.1}{Standard deviation of forth level Within Factor, 1st level Between Factor}

\item{s1.2}{Standard deviation of first level Within Factor, 2nd level Between Factor}

\item{s2.2}{Standard deviation of second level Within Factor, 2nd level Between Factor}

\item{s3.2}{Standard deviation of third level Within Factor, 2nd level Between Factor}

\item{s4.2}{Standard deviation of forth level Within Factor, 2nd level Between Factor}

\item{r1.2_1}{correlation Within Factor Level 1 and Within Factor, Level 2, 1st level Between}

\item{r1.3_1}{correlation Within Factor Level 1 and Within Factor, Level 3, 1st level Between}

\item{r1.4_1}{correlation Within Factor Level 1 and Within Factor, Level 4, 1st level Between}

\item{r2.3_1}{correlation Within Factor Level 1 and Within Factor, Level 3, 1st level Between}

\item{r2.4_1}{correlation Within Factor Level 1 and Within Factor, Level 4, 1st level Between}

\item{r3.4_1}{correlation Within Factor Level 1 and Within Factor, Level 4, 1st level Between}

\item{r1.2_2}{correlation Within Factor Level 1 and Within Factor, Level 2, 2nd level Between}

\item{r1.3_2}{correlation Within Factor Level 1 and Within Factor, Level 3, 2nd level Between}

\item{r1.4_2}{correlation Within Factor Level 1 and Within Factor, Level 4, 2nd level Between}

\item{r2.3_2}{correlation Within Factor Level 1 and Within Factor, Level 3, 2nd level Between}

\item{r2.4_2}{correlation Within Factor Level 1 and Within Factor, Level 4, 2nd level Between}

\item{r3.4_2}{correlation Within Factor Level 1 and Within Factor, Level 4, 2nd level Between}

\item{r}{sets same correlations between DVs on all factor levels (seriously, just use this)}

\item{s}{sets same standard deviation for factor levels (see comment above)}

\item{n}{for each between group level}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for the One Factor Within Subjects and One Factor Between ANOVA
}
\description{
Compute power for a One Factor Within Subjects and One Factor Between ANOVA with up to two by four levels (within).
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
win1bg1(m1.1 = -.25, m2.1=0, m3.1=0.10, m4.1=.15,
m1.2=-.25,m2.2=-.25,m3.2=-.25, m4.2=-.25,
s1.1 = .4, s2.1=.5, s3.1=0.6, s4.1=.7,
s1.2=.4,s2.2=.5,s3.2=.6, s4.2=.7,n = 50,
r1.2_1=.5,r1.3_1=.3,r1.4_1=.15,r2.3_1=.5,r2.4_1=.3,r3.4_1=.5,
r1.2_2=.5,r1.3_2=.3,r1.4_2=.15, r2.3_2=.5,r2.4_2=.3,r3.4_2=.5)
win1bg1(m1.1 = -.25, m2.1=0, m3.1=0.10, m4.1=.15,
m1.2=-.25,m2.2=-.25,m3.2=-.25, m4.2=-.25, s=.4, r = .5, n = 100)
}
