% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modmed8.R
\name{modmed8}
\alias{modmed8}
\title{Compute Power for Power for Model 8 Conditional Processes Using Joint Significance
Requires correlations between all variables as sample size.
This is the recommended approach for determining power}
\usage{
modmed8(
  rxw,
  rxm,
  rxxw,
  rxy,
  rwm = 0,
  rwy,
  rxwm,
  rxwy,
  rwxw,
  rmy,
  n,
  alpha = 0.05,
  rep = 5000
)
}
\arguments{
\item{rxw}{Correlation between predictor (x) and moderator (w)}

\item{rxm}{Correlation between predictor (x) and mediator (m)}

\item{rxxw}{Correlation between predictor (x) and interaction term (xw) - defaults to 0}

\item{rxy}{Correlation between DV (y) and predictor (x)}

\item{rwm}{Correlation between moderator (w) and mediator (m)}

\item{rwy}{Correlation between DV (y) and moderator (w)}

\item{rxwm}{Correlation between mediator (m) and interaction (xw) - Key value}

\item{rxwy}{Correlation between DV (y) and interaction (xw) - defaults to 0}

\item{rwxw}{Correlation between moderator (w) and interaction (xw) - defaults to 0}

\item{rmy}{Correlation between DV (y) and mediator (m)}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{rep}{Number of samples drawn (defaults to 5000)}
}
\value{
Power for Model 8 Conditional Processes
}
\description{
Compute Power for Power for Model 8 Conditional Processes Using Joint Significance
Requires correlations between all variables as sample size.
This is the recommended approach for determining power
}
\examples{
\donttest{modmed8(rxw<-.21, rxm<-.31, rxxw=0, rxy=.32,rwm=.40,
rmy=.19,rwy=.22,rwxw=.23,rxwm=.24,rxwy=.18,alpha=.05,rep=1000,n=400)}
}
