% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_table2.R
\name{px_title}
\alias{px_title}
\alias{px_title.px}
\title{TITLE}
\usage{
px_title(x, value, validate)

\method{px_title}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string to set the value for all languages or a data frame with columns 'language' and 'value' to set it for specific languages. If 'value' is missing, the current TITLE is returned. If NULL, TITLE is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object, a character string, or a data frame.
}
\description{
Inspect or change TITLE.

TITLE can only be removed if DESCRIPTION is set.
}
\examples{
# Set TITLE for all languages
x1 <-
  px(population_gl) |>
  px_title('Population GR')

# Print TITLE
px_title(x1)

# Set TITLE for individual languages
library(tibble)
x2 <-
  x1 |>
  px_languages(c('en', 'kl')) |>
  px_title(tribble(~language, ~value,
                      'en', 'Population GR',
                      'kl', 'Innuttaasut KL'))
px_title(x2)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A36\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C533\%2C0\%5D}{Statistics Sweden's documentation}

\code{\link[=px_description]{px_description()}}
}
