% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbymc_0.1.4.R
\name{qbymc}
\alias{qbymc}
\title{qbymc, a q value estimator founded upon medcouple.}
\usage{
qbymc(x)
}
\arguments{
\item{x}{numeric vector}

}
\value{
a number q < 3, and the standard error.
}
\description{
Given a random data set, the 'qbymc' uses 
               the medcouple, a robust measure of tail
               weights, to yield a 'q' value, a characteristic 
               entropic index  of the q-gaussian distributions.
}
\examples{
set.seed(0002)
rr <- rqgauss(1000,1.333)
qbymc(rr)

}
\author{
Emerson Luis de Santa Helena , Wagner Santos de Lima
}
\references{
de Santa Helena, E. L., Nascimento, C. M., and Gerhardt, G. J., (2015) Alternative way to 
 charecterize a q-gaussian distribution by a robust heavy tail measurement. Physica A, (435):44-50.
}
\seealso{
Robustbase for medcouple.
            \code{\link[robustbase]{mc}}
}

