% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCH_functions.R
\name{GetHinfoEqual}
\alias{GetHinfoEqual}
\title{Generate H0/H1 configurations and specify the ones corresponding to the composed H1}
\usage{
GetHinfoEqual(Q, Equal, Consecutive = FALSE)
}
\arguments{
\item{Q}{number of test series to be combined}

\item{Equal}{How many H1 hypotheses exactly for the item to be of interest ?}

\item{Consecutive}{Should the significant test series be consecutive ? Default=FALSE}
}
\value{
A list of two objects 'Hconfig' and 'Hconfig.H1'.
Hconfig is the list of all possible combination of H0 and H1 hypotheses among Q hypotheses tested.
Hconfig.H1 is the vector of components of Hconfig that correspond to the 'Equal' specification.
}
\description{
Generate H0/H1 configurations and specify the ones corresponding to the composed H1
}
\examples{
GetHinfoEqual(4,2)
}
\seealso{
\code{\link[=GetHinfo]{GetHinfo()}}
}
