% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_functions.R
\name{EM_calibration_gaussian}
\alias{EM_calibration_gaussian}
\title{EM calibration in the case of the gaussian copula (unsigned)}
\usage{
EM_calibration_gaussian(
  Hconfig,
  F0Mat,
  F1Mat,
  fHconfig,
  R.init,
  Prior.init,
  Precision = 1e-06
)
}
\arguments{
\item{Hconfig}{A list of all possible combination of H0 and H1 hypotheses generated by the \code{\link[=GetHconfig]{GetHconfig()}} function.}

\item{F0Mat}{a matrix containing the evaluation of the marginal cdf under H0 at each items, each column corresponding to a p-value serie.}

\item{F1Mat}{a matrix containing the evaluation of the marginal cdf under H1 at each items, each column corresponding to a p-value serie.}

\item{fHconfig}{a matrix containing config densities evaluated at each items, each column corresponding to a configurations.}

\item{R.init}{the initialization of the correlation matrix of the gaussian copula parameter.}

\item{Prior.init}{the initialization of prior probabilities for each of the H-configurations.}

\item{Precision}{Precision for the stop criterion. (Default is 1e-6)}
}
\value{
A list of 2 objects 'priorHconfig' and 'Rcopula'.
Object 'priorHconfig' is a vector of estimated prior probabilities for each of the H-configurations.
Object 'Rcopula' is the estimated correlation matrix of the gaussian copula.
}
\description{
EM calibration in the case of the gaussian copula (unsigned)
}
