% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_reliability.R
\name{reliability}
\alias{reliability}
\title{Measurement model reliability and internal consistence}
\usage{
reliability(qcpm)
}
\arguments{
\item{qcpm}{is an object of class \code{qcpm}}
}
\value{
A table containing, for each block, the outer mode (A or B), 
the number of manifest variables, Cronbach's alpha, Dillon-Goldstein's rho, 
Dijkstra-Henseler rho, and first and second eigenvalue of the manifest variable 
correlation matrix.
}
\description{
\code{reliability} returns the classical indices used in PLS-PM to assess 
the reliability and internal consistence of the measurement model (Hair et al., 2019). 
In order it provides: Cronbach's alpha, Dillon-Goldstein's rho, the Dijkstra-Henseler rho, and 
first and second eigenvalue of the correlation matrix of the manifest variables. The function 
also returns the outer mode (A or B) and the number of manifest variables for each block.
}
\details{
The function only returns Dijkstra-Henseler rho values for quantile 0.5. When mode 
B is selected, or there are some intra-block inverse correlations, the Dijkstra-Henseler rho, 
Cronbach's alpha, and Dillon-Goldstein's rho are not calculated.
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

# Define the model using laavan sintax. Use a set of regression formulas defining 
# firstly the structural model and then the measurement model
model <- "
ECOW ~ EDU
HEALTH ~ EDU + ECOW

# Reflective measurement model
EDU =~ EDU1 + EDU2 + EDU3 + EDU4 + EDU5 + EDU6 + EDU7
ECOW =~ ECOW1 + ECOW2 + ECOW3 + ECOW4 + ECOW5 + ECOW6
HEALTH =~  HEALTH1 + HEALTH2 + HEALTH3
"


# Apply qcpm
well.qcpm = qcpm(model,province)
reliability(well.qcpm)   

}
\references{
Hair, J.F., Risher, J.J., Sarstedt, M. and Ringle, C.M. (2019). When to 
use and how to report the results of PLS-SEM. \emph{European Business Review}, \bold{31 (1)},
 pp. 2--24, doi: 10.1108/EBR-11-2018-0203

Sanchez, G. (2013). PLS Path Modeling with R Trowchez Editions. Berkeley, 2013. 
Available at \url{https://www.gastonsanchez.com/PLS_Path_Modeling_with_R.pdf}.
}
\seealso{
\code{\link{qcpm}}, \code{\link{assessment}}, \code{\link{boot}}, and 
\code{\link{summary}}
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
