% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdqcd.R
\name{fdqcd}
\alias{fdqcd}
\title{It creates a data object to be used in Functional Data Quality Control}
\usage{
fdqcd(x, data.name = NULL, ...)
}
\arguments{
\item{x}{Matrix of set cases with dimension (n x m), where n is the number of curves 
and m are the points observed in each curve.}

\item{data.name}{a string that specifies the title displayed on the plots. 
If not provided it is taken from the name of the object's data.}

\item{...}{arguments passed to or from methods.}
}
\description{
Create an object of class 'fdqcd' to perform statistical quality control.
This object is used to plot Functional Data Control Charts.
}
\examples{
library(qcr)
m <- 30
tt<-seq(0,1,len=m)
mu<-30 * tt * (1 - tt)^(3/2)
n0 <- 100
set.seed(12345)
mdata<-matrix(NA,ncol=m,nrow=n0)
sigma <- exp(-3*as.matrix(dist(tt))/0.9)
for (i in 1:n0) mdata[i,]<- mu+0.5*mvrnorm(mu = mu,Sigma = sigma )
fdchart <- fdqcd(mdata)
plot(fdchart,type="l",col="gray")
}
