\name{synonyms}
\alias{syn}
\alias{synonyms}
\title{Search For Synonyms}
\usage{
  synonyms(terms, return.list = TRUE, multiwords = TRUE,
    report.null = TRUE)

  syn(terms, return.list = TRUE, multiwords = TRUE,
    report.null = TRUE)
}
\arguments{
  \item{terms}{The terms to find synonyms for.}

  \item{return.list}{logical.  If \code{TRUE} returns the
  output for multiple synonyms as a list by search term
  rather than a vector.}

  \item{multiwords}{logical.  IF \code{TRUE} retains vector
  elements that contain phrases (defined as having one or
  more spaces) rather than a single word.}

  \item{report.null}{logical.  If \code{TRUE} reports the
  words that no match was found at the head of the output.}
}
\value{
  Returns a list of vectors or vector of possible words
  that match term(s).
}
\description{
  Search for synonyms that match term(s).
}
\examples{
\dontrun{
synonyms(c("the", "cat", "job", "environment", "read", "teach"))
head(syn(c("the", "cat", "job", "environment", "read", "teach"),
    return.list = FALSE), 30)
syn(c("the", "cat", "job", "environment", "read", "teach"), multiwords = FALSE)
}
}
\references{
  The synonyms dictionary (see \code{\link[qdap]{SYNONYM}})
  was generated by web scraping the
  \href{http://dictionary.reverso.net/english-synonyms/}{Reverso
  Online Dictionary}. The word list fed to
  \href{http://dictionary.reverso.net/english-synonyms/}{Reverso}
  is the unique words from the combination of
  \code{\link[qdap]{DICTIONARY}} and
  \code{\link[qdap]{labMT}}.
}

