% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/object_pronoun_type.R
\name{object_pronoun_type}
\alias{object_pronoun_type}
\title{Count Object Pronouns Per Grouping Variable}
\usage{
object_pronoun_type(text.var, grouping.var = NULL,
  object.pronoun.list = NULL, ...)
}
\arguments{
\item{text.var}{The text variable}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates
one word list for all text.  Also takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{object.pronoun.list}{A named list of object pronouns.  See
\strong{Details} for more.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{termco}}}
}
\value{
Returns a list, of class "object_pronoun_type", of data frames
regarding objectpronoun word counts:
\item{preprocessed}{List of uncollapsed dataframes (raw, prop, rnp) of the class "termco" that contain all searchable object pronouns.}
\item{raw}{raw word counts by grouping variable}
\item{prop}{proportional word counts by grouping variable; proportional to
each individual's object pronoun use}
\item{rnp}{a character combination data frame of raw and proportional object pronoun use}
}
\description{
Count the number of object pronouns per grouping variables.
}
\details{
The following object pronoun categories are the default searched terms:
\itemize{
    \item me = c(" me ", " my ", " mine ")
    \item us = c(" us ", " our ", " ours ")
    \item you = c(" you'd ",  " you'll ", " you're ", " you've ", " you ", " your ")
    \item him = c(" him ", " his ")
    \item her = c(" her ", " hers ")
    \item them = c(" them ")
    \item their = c(" their ", "theirs ")
    \item it = c(" it'd ", " it'll ", " it's ", " it ")
}
}
\examples{
\dontrun{
dat <- pres_debates2012
dat <- dat[dat$person \%in\% qcv(ROMNEY, OBAMA), ]
(out <- object_pronoun_type(dat$dialogue, dat$person))
plot(out)
plot(out, 2)
plot(out, 3)
plot(out, 3, ncol=2)

scores(out)
counts(out)
proportions(out)
preprocessed(out)

plot(scores(out))
plot(counts(out))
plot(proportions(out))
}
}
\seealso{
\code{\link[qdap]{subject_pronoun_type}},
\code{\link[qdap]{pronoun_type}}
}
\keyword{pronouns}

