% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_length.R
\name{word_length}
\alias{word_length}
\title{Count of Word Lengths Type}
\usage{
word_length(
  text.var,
  grouping.var = NULL,
  percent = TRUE,
  zero.replace = 0,
  digits = 2,
  ...
)
}
\arguments{
\item{text.var}{The text variable.}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates 
one word list for all text.  Also takes a single grouping variable or a list 
of 1 or more grouping variables.}

\item{percent}{logical.  If \code{TRUE} output given as percent.  If 
\code{FALSE} the output is proportion.}

\item{zero.replace}{Value to replace 0 values with.}

\item{digits}{Integer; number of decimal places to round when printing.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{bag_o_words}}.}
}
\value{
Returns a list of:
\item{count}{Dataframe of word length counts by grouping variable(s).}
\item{prop}{Dataframe of the proportions of word length counts by 
grouping variable.} 
\item{rnp}{Dataframe of the frequency and proportions of word length counts by 
grouping variable.} 
\item{percent}{The value of percent used for plotting purposes.}
\item{zero.replace}{The value of zero.replace used for plotting purposes.}
}
\description{
Transcript apply word length counts.
}
\examples{
\dontrun{
(x <- with(DATA, word_length(state, person)))
plot(x)
scores(x)
proportions(x)
counts(x)
plot(scores(x))
plot(proportions(x))
plot(counts(x))

(x2 <- word_length(DATA[["state"]]))
(x2 <- word_length(DATA[["state"]], apostrophe.remove=TRUE))

## Example Visualizations with Presidential Debate Data
library(tidyr)
(x_long <- proportions(x) \%>\% 
    gather("Letter_Length", "Proportion", -c(1:2)))
ggplot(x_long, aes(x = Letter_Length, y = Proportion, color=person, group=person)) +
    geom_line(size=.8)


(x3 <- with(pres_debates2012, word_length(dialogue, person)))
(x_long2 <- proportions(x3) \%>\% 
    gather("Letter_Length", "Proportion", -c(1:2)))
ggplot(x_long, aes(x = Letter_Length, weight = Proportion, fill=person, group=person)) +
    geom_bar()

ggplot(x_long, aes(x = Letter_Length, weight = Proportion, fill=person)) +
    geom_bar() + 
    facet_wrap(~person, ncol=1)
        
ggplot(x_long, aes(x = Letter_Length, weight = Proportion, fill=person)) +
    geom_bar() + 
    coord_flip() + 
    facet_wrap(~person, ncol=1)

ggplot(x_long, aes(x = person, weight = Proportion)) +
    geom_bar(fill="grey40") + 
    coord_flip() + 
    facet_grid(Letter_Length~.)
}
}
\keyword{letters}
