% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rm_tag.R
\name{rm_tag}
\alias{rm_tag}
\title{Remove/Replace/Extract Person Tags}
\usage{
rm_tag(text.var, trim = !extract, clean = TRUE, pattern = "@rm_tag",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_tag} uses the
\code{rm_tag} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the person tags are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with person tags removed.
}
\description{
Remove/replace/extract person tags from a string.
}
\details{
The default regex pattern \code{"(?<![@\\w])@([a-z0-9_]+)\\b"} is
more liberal and searches for the at (@) symbol followed by any word.  This
can be accessed via \code{pattern = "@rm_tag"}.  Twitter user names are more
constrained.  A second regex (\code{"(?<![@\\w])@([a-z0-9_]{1,15})\\b"}) is
provide that contains the latter word to substring that begins with an at
(@) followed by a word composed of alpha-numeric characters and underscores,
no longer than 15 characters.  This can be accessed via
\code{pattern = "@rm_tag2"} (see \bold{Examples}).
}
\examples{
x <- c("@hadley I like #rstats for #ggplot2 work.",
    "Difference between #magrittr and #pipeR, both implement pipeline operators for #rstats:
        http://renkun.me/r/2014/07/26/difference-between-magrittr-and-pipeR.html @timelyportfolio",
    "Slides from great talk: @ramnath_vaidya: Interactive slides from Interactive Visualization
        presentation #user2014. http://ramnathv.github.io/user2014-rcharts/#1",
    "tyler.rinker@gamil.com is my email",
    "A non valid Twitter is @abcdefghijklmnopqrstuvwxyz"
)

rm_tag(x)
rm_tag(rm_hash(x))
rm_tag(x, extract=TRUE)

## more restrictive Twitter regex
rm_tag(x, extract=TRUE, pattern="@rm_tag2")

## Remove only the @ sign
rm_tag(x, replacement = "\\\\3")
rm_tag(x, replacement = "\\\\3", pattern="@rm_tag2")
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{as_numeric}},
  \code{\link{as_numeric2}}, \code{\link{rm_number}};
  \code{\link{as_time}}, \code{\link{as_time2}},
  \code{\link{rm_time}}, \code{\link{rm_transcript_time}};
  \code{\link{rm_abbreviation}}; \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{rm_caps_phrase}}; \code{\link{rm_caps}};
  \code{\link{rm_citation_tex}}; \code{\link{rm_citation}};
  \code{\link{rm_city_state_zip}};
  \code{\link{rm_city_state}}; \code{\link{rm_date}};
  \code{\link{rm_default}}; \code{\link{rm_dollar}};
  \code{\link{rm_email}}; \code{\link{rm_emoticon}};
  \code{\link{rm_endmark}}; \code{\link{rm_hash}};
  \code{\link{rm_nchar_words}}; \code{\link{rm_non_ascii}};
  \code{\link{rm_non_words}}; \code{\link{rm_percent}};
  \code{\link{rm_phone}}; \code{\link{rm_postal_code}};
  \code{\link{rm_repeated_characters}};
  \code{\link{rm_repeated_phrases}};
  \code{\link{rm_repeated_words}};
  \code{\link{rm_title_name}};
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{rm_white}}, \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{rm_zip}}
}
\keyword{person}
\keyword{tag}
\keyword{twitter}

