% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{qspec.qslw}
\alias{qspec.qslw}
\title{Quantile-Smoothing-Lag-Window (QSLW) Estimator of Quantile Spectrum}
\usage{
qspec.qslw(
  y,
  tau,
  y.qdft = NULL,
  M = NULL,
  method = c("gamm", "sp"),
  spar = "GCV",
  n.cores = 1,
  cl = NULL
)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{y.qdft}{matrix or array of pre-calculated QDFT (default = \code{NULL}: compute from \code{y} and \code{tau});
if \code{y.qdft} is supplied, \code{y} and \code{tau} can be left unspecified}

\item{M}{bandwidth parameter of lag window (default = \code{NULL}: quantile periodogram)}

\item{method}{smoothing method: \code{"gamm"} for \code{mgcv::gamm()} (default), 
\code{"sp"} for \code{stats::smooth.spline()}}

\item{spar}{smoothing parameter in \code{smooth.spline()} if \code{method = 'sp'} (default = \code{"GCV"})}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = \code{NULL})}
}
\value{
A list with the following elements:
  \item{spec}{matrix or array of quantile spectrum/cross-spectrum}
  \item{lw}{lag-window sequence}
  \item{qdft}{matrix or array of quantile discrete Fourier transform if \code{y.qdft = NULL}}
}
\description{
This function computes quantie-smoothing-lag-window (QSLW estimate of quantile spectrum/cross-spectrum 
from time series or quantile discrete Fourier transform (QDFT).
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qper.qslw <- qspec.qslw(cbind(y1,y2),tau,M=5,method="sp",spar=0.9)$spec
qfa.plot(ff[sel.f],tau,Re(y.qper.qslw[1,1,sel.f,]))
}
