% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_aug.R
\name{cc_aug}
\alias{cc_aug}
\title{Calibration coefficient for an augmented signature proportion}
\usage{
cc_aug(sig_rep, sig_scale, cc_all, use_fa, dist_meas = 1, gamma = 1)
}
\arguments{
\item{sig_rep}{A numeric matrix containing fatty acid signatures with
proportions from all fatty acids.  See Details.}

\item{sig_scale}{A numeric matrix containing fatty acid signatures with
proportions from a subset of all fatty acids and an augmented proportion.
See Details.}

\item{cc_all}{A numeric vector of calibration coefficients for the fatty
acids in \code{sig_rep}.}

\item{use_fa}{A logical vector denoting the fatty acids in \code{sig_rep}
that are also in \code{sig_scale}.}

\item{dist_meas}{An integer indicator of the distance measure to compute.
Default value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}
}
\value{
A list containing the following elements: \describe{
  \item{cc}{A numeric vector of calibration coefficients for the augmented
    signatures.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
}
}
\description{
\code{cc_aug} computes the optimal calibration coefficient for an
augmented signature proportion (Bromaghin et al. 2016).
If signature augmentation is to be used, the user must call \code{cc_aug}
after first calling \code{\link{prep_sig}} with the prey signature data, in
order to derive a calibration coefficient for the augmented signature.
}
\section{Details}{

Calibration coefficients provide a one-to-one mapping between the prey and
predator spaces (Bromaghin et al. 2015).  However, when using signature
augmentation (Bromaghin et al. 2016), no calibration coefficient is
available for the augmented proportion and the function \code{cc_aug} was
developed to remedy that lack.

\code{cc_aug} transforms complete prey signatures in \code{sig_rep} to the
predator space, censors them using \code{fa}, and then augments them.
The subset of calibration coefficients in \code{cc_all} corresponding to
\code{fa} are combined with a calibration coefficient for the  augmented
proportion, the censored signatures in \code{sig_scale} are also transformed to
the predator space, and the distance between the two sets of censored
signatures is computed.  The calibration coefficient for the augmented
proportion is taken as the value that minimizes the distance.  The function
Rsolnp::solnp() is used to minimize the distance.

The entity passed as the argument \code{fa} is intended to be the
corresponding entity returned by a call to \code{prep_fa}.  Similarly,
the entities passed as the arguments \code{sig_rep} and \code{sig_scale}
are intended to be the corresponding entities returned by a call to
\code{prep_sig} with data in a prey library.  Consequently, no error
checks are made on these objects.  Please refer to the documentation for
\code{\link{prep_fa}} and \code{\link{prep_sig}} for additional details.

Use of Rsolnp::solnp limits the ability to return any errors from the
function \code{dist_between_2_sigs}.  A crash may be caused by passing
invalid values for the arguments \code{dist_meas} or \code{gamma}.  Please
refer to documentation for the function \code{\link{dist_between_2_sigs}} for
additional information about valid values for these arguments.

Utility and external functions called by \code{cc_aug}:
  \itemize{
  \item \code{\link{dist_between_2_sigs}}
  \item Rsolnp::solnp
  }
}

\section{References}{

Bromaghin, J.F., S.M. Budge, and G.W. Thiemann. 2016. Should fatty
  acid signature proportions sum to 1 for diet estimation?
  \emph{Ecological Research} 31:597-606.

Bromaghin, J.F., K.D. Rode, S.M. Budge, and G.W. Thiemann. 2015. Distance
  measures and optimization spaces in quantitative fatty acid signature
  analysis. \emph{Ecology and Evolution} 5:1249-1262.
}
\examples{
cc_aug(sig_rep = matrix(c(0.05, 0.10, 0.30, 0.55,
                          0.04, 0.11, 0.29, 0.56,
                          0.10, 0.05, 0.35, 0.50), ncol = 3),
       sig_scale = matrix(c(0.40, 0.50, 0.10,
                            0.45, 0.49, 0.06,
                            0.35, 0.45, 0.20), ncol = 3),
       cc_all = c(0.75, 1.05, 1.86, 0.80),
       use_fa = c(FALSE, FALSE, TRUE, TRUE))

cc_aug(sig_rep = matrix(c(0.05, 0.10, 0.30, 0.55,
                          0.04, 0.11, 0.29, 0.56,
                          0.10, 0.05, 0.35, 0.50), ncol = 3),
       sig_scale = matrix(c(0.40, 0.50, 0.10,
                            0.45, 0.49, 0.06,
                            0.35, 0.45, 0.20), ncol = 3),
       cc_all = c(0.75, 1.05, 1.86, 0.80),
       use_fa = c(FALSE, FALSE, TRUE, TRUE),
       dist_meas = 1)

cc_aug(sig_rep = matrix(c(0.05, 0.10, 0.30, 0.55,
                          0.04, 0.11, 0.29, 0.56,
                          0.10, 0.05, 0.35, 0.50), ncol = 3),
       sig_scale = matrix(c(0.40, 0.50, 0.10,
                            0.45, 0.49, 0.06,
                            0.35, 0.45, 0.20), ncol = 3),
       cc_all = c(0.75, 1.05, 1.86, 0.80),
       use_fa = c(FALSE, FALSE, TRUE, TRUE),
       dist_meas = 2)

cc_aug(sig_rep = matrix(c(0.05, 0.10, 0.30, 0.55,
                          0.04, 0.11, 0.29, 0.56,
                          0.10, 0.05, 0.35, 0.50), ncol = 3),
       sig_scale = matrix(c(0.40, 0.50, 0.10,
                            0.45, 0.49, 0.06,
                            0.35, 0.45, 0.20), ncol = 3),
       cc_all = c(0.75, 1.05, 1.86, 0.80),
       use_fa = c(FALSE, FALSE, TRUE, TRUE),
       dist_meas = 3,
       gamma = 0.25)

cc_aug(sig_rep = matrix(c(0.05, 0.10, 0.30, 0.55,
                          0.04, 0.11, 0.29, 0.56,
                          0.10, 0.05, 0.35, 0.50), ncol = 3),
       sig_scale = matrix(c(0.40, 0.50, 0.10,
                            0.45, 0.49, 0.06,
                            0.35, 0.45, 0.20), ncol = 3),
       cc_all = c(0.75, 1.05, 1.86, 0.80),
       use_fa = c(FALSE, FALSE, TRUE, TRUE),
       dist_meas = 3)

}

