% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_prey_part.R
\name{make_prey_part}
\alias{make_prey_part}
\title{Make prey partition}
\usage{
make_prey_part(sig, clust, n_clust)
}
\arguments{
\item{sig}{A matrix of scaled signatures ready for analysis, intended to be
the object \code{sig_scale} returned by the function \code{prep_sig}.}

\item{clust}{A data frame containing cluster definitions, intended to be the
object \code{clust} returned by the function \code{dimac}.}

\item{n_clust}{An integer vector constructed by the user to specify the
number of clusters into which each prey type should be partitioned.}
}
\value{
A list containing the following elements: \describe{
  \item{type}{A character vector of the partitioned type of each signature.}
  \item{id}{A character vector of the unique sample ID of each signature.}
  \item{n_types}{The number of unique types in the partitioned library.}
  \item{uniq_types}{A character vector of the unique types, sorted
    alphanumerically.}
  \item{type_ss}{The number of signatures for each unique \code{type}.}
  \item{loc}{A vector or matrix giving the first and last locations of the
    signatures of each \code{type}, after being sorted by \code{type} and
    \code{id}.}
  \item{sig_part}{A matrix of partitioned signatures ready for analysis,
    sorted by \code{type} and \code{id}, in column-major format.}
  \item{pool_pre}{A matrix to pre-multiply diet estimates associated with a
    partitioned library to pool estimates back to the original prey types.}
  \item{pool_post}{A matrix to post-multiply diet estimates associated with a
    partitioned library to pool estimates back to the original prey types.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The function \code{make_prey_part} partitions a prey library into clusters
based on user specifications informed by the results of a call to the
function \code{dimac}.
}
\section{Details}{

The function \code{make_prey_part} partitions a matrix of prey signatures
and into a larger number of prey types based on user input (in the vector
\code{n_clust}) informed by the results of a preceding call to the clustering
function \code{dimac}.  The signatures in \code{sig} are presumed to be
ready for analysis, which is best accomplished by a call to the function
\code{prep_sig}.

For each prey type, the column in \code{clust} designated by the
corresponding integer in \code{n_clust} is accessed and used to partition the
prey type.  For example, if the element of \code{n_clust} is 1, the first
column of \code{clust} is accessed and the prey type is not partitioned.  If
the element of \code{n_clust} is 3, the third column of \code{clust} is
accessed and the prey type is partitioned into three clusters.

The length of the integer vector \code{n_clust} must equal the number of
unique types in \code{type}.  The integers themselves should be between 1 and
the number of signatures of each type.

After all prey types have been partitioned, the prey signatures are sorted by
\code{type} and \code{id}.  The matrix \code{rep_grp} is created to map the
new prey types to the original prey types.  Multiplying diet estimates
corresponding to a partitioned prey library \code{sig_part} by \code{rep_grp}
pools the diet estimates into the original prey types.

Please refer to the vignette and documentation for the functions
\code{\link{dimac}} and \code{\link{prep_sig}} for additional
information.
}
\examples{
make_prey_part(sig = matrix(c(0.01, 0.20, 0.30, 0.49,
                              0.05, 0.14, 0.39, 0.42,
                              0.07, 0.21, 0.28, 0.44,
                              0.04, 0.19, 0.34, 0.43,
                              0.12, 0.29, 0.39, 0.20,
                              0.15, 0.28, 0.34, 0.23,
                              0.17, 0.21, 0.31, 0.31,
                              0.18, 0.22, 0.28, 0.32), ncol = 8),
               data.frame(type = c("prey_1", "prey_1", "prey_1", "prey_2",
                                   "prey_2", "prey_2", "prey_2", "prey_2"),
                          id = c("1-1", "1-2", "1-3", "2-1",
                                 "2-2", "2-3", "2-4", "2-5"),
                          clust_1 = c(1, 1, 1, 1, 1, 1, 1, 1),
                          clust_2 = c(1, 2, 1, 2, 1, 1, 2, 2),
                          clust_3 = c(1, 2, 3, 3, 1, 2, 3, 3),
                          clust_4 = c(0, 0, 0, 4, 1, 2, 3, 4)),
               n_clust = c(1, 2))

}

