% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmoid.R
\name{sigmoid}
\alias{sigmoid}
\title{Sigmoid function and its derivatives}
\usage{
sigmoid(y, deriv = FALSE)
}
\arguments{
\item{y}{a numeric vector.}

\item{deriv}{if \code{TRUE} alse the first three derivatives of the sigmoid function will be computed.}
}
\value{
If \code{deriv==FALSE}, it returns a numeric vector equal to \code{1/(1+exp(-x))}. If
        \code{deriv==TRUE} it returns a list where the slot \code{$D0} contains \code{1/(1+exp(-x))}, 
        while \code{$D1}, \code{$D2} and \code{$D3} contain its first three derivatives.
}
\description{
Calculates the sigmoid function and its derivatives.
}
\examples{
library(qgam)
set.seed(90)
h <- 1e-6
p <- rnorm(1e4, 0, 1e6)
sigmoid(p[1:50]) - 1/(1+exp(-p[1:50]))

##### Testing sigmoid derivatives
e1 <- abs((sigmoid(p+h) - sigmoid(p-h)) / (2*h) - sigmoid(p, TRUE)[["D1"]]) / (2*h)
e2 <- abs((sigmoid(p+h, TRUE)$D1 - sigmoid(p-h, TRUE)$D1) / 
      (2*h) - sigmoid(p, TRUE)[["D2"]]) / (2*h)
e3 <- abs((sigmoid(p+h, TRUE)$D2 - sigmoid(p-h, TRUE)$D2) / 
      (2*h) - sigmoid(p, TRUE)[["D3"]]) / (2*h)

if( any(c(e1, e2, e3) > 1) ) stop("Sigmoid derivatives are not estimated accurately")


}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>.
}
