% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krige.R
\name{covarTx}
\alias{covarTx}
\title{Variance matrix approximation}
\usage{
covarTx(qsd, W = NULL, theta = NULL, cvm = NULL, useVar = FALSE,
  doInvert = FALSE)
}
\arguments{
\item{qsd}{object of class \code{\link{QLmodel}}}

\item{W}{weight matrix for weighted average approximation}

\item{theta}{parameter vector for weighted average approximation}

\item{cvm}{list of fitted cross-validation models, see \code{\link{prefitCV}}}

\item{useVar}{logical, if \code{TRUE}, then use prediction variances (see details)}

\item{doInvert}{if \code{TRUE}, return the inverse of the variance matrix approximation}
}
\value{
List of variance matrices with the following structure:
	\item{VTX}{ variance matrix approximation}
 \item{sig2}{ if applicable, kriging prediction variances of statistics at `\code{theta}`}
 \item{var}{ matrix `\code{VTX}` with added variances `\code{sig2}` to the diagonal terms}
 \item{inv}{ if applicable, the inverse of either `\code{VTX}` or `\code{var}`}
}
\description{
Approximating the variance-covariance matrix of statistics
}
\details{
The function estimates the variance matrix of statistics at some (unsampled) point `\code{theta}` by either
 averaging (the \emph{Cholesky} decomposed terms or matrix logarithms) over all simulated variance matrices
 of statistics at previously evaluated points of the parameter space or by a kriging approach which treats the Cholesky
 decomposed terms of each variance matrix as a data vector for kriging.

 In addition, a Nadaraya-Watson kernel-weighted average approximation can also be applied in order to bias the variance
 estimation towards a more locally weighted estimation, where smaller weights are assigned to points being more
 distant to an estimate of the model parameter `\code{theta}`. A reasonable symmetric weighting matrix 
 `\code{W}` of size equal to the problem dimension, say \code{q}, can be freely chosen by the user. In addition, the user can select
 different types of variance averaging methods such as "\code{cholMean}", "\code{wcholMean}", "\code{logMean}", "\code{wlogMean}"
 or "\code{kriging}" defined by `\code{qsd$var.type}`, where the prefix "\code{w}" indicats its corresponding weighted version of
 the approximation type. Depending on the type of kriging for the statistics, `\code{qsd$krig.type}`, prediction variances
 \eqn{\sigma(\theta)} of the sample mean of statistics at `\code{theta}` are added. If `\code{qsd$krig.type}` equals
 "\code{dual}", see \code{\link{QLmodel}}, then no prediction variances are used at all and thus the variance matrix estimate of
 the statistics only includes the variances due to simulation replications and not the ones due to the use of kriging approximations
 of the statistics. Otherwise, including the prediction variances, the mean variance matrix estimate is given by
 \deqn{ \hat{V}+\textrm{diag}(\sigma(\theta)),} 
	where \eqn{\hat{V}} denotes one of the above variance approximation types.

 The prediction variances \eqn{\sigma} are either derived from the kriging results of statistics or based on a (possibly more robust)
 cross-validation (CV) approach, see vignette for details. Finally, we can switch off using prediction variances of either type by setting
 `\code{useVar}`=\code{FALSE}. In general, this should be avoided. However, if the estimation problem under investigation is \emph{simple enough},
 then this choice may be still useful.
}
\examples{
 data(normal)
 # average approximation of variance matrices
 covarTx(qsd,theta=c("mu"=2,"sd"=1))

}
\author{
M. Baaske
}
