% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_helpers.R
\name{drop_type_vars}
\alias{drop_type_vars}
\title{Drop automatically generated Variables}
\usage{
drop_type_vars(data_frame)
}
\arguments{
\item{data_frame}{The data frame with automatically generated variables.}
}
\value{
Returns a data frame without the variables TYPE, TYPE_NR and DEPTH.
}
\description{
If \code{\link[=summarise_plus]{summarise_plus()}} is used with the nested options "all" or "single", three
variables are automatically generated: TYPE, TYPE_NR and DEPTH. With this functions
these variables are dropped.
}
\examples{
# Example format
sex. <- discrete_format(
    "Total"  = 1:2,
    "Male"   = 1,
    "Female" = 2)

# Example data frame
my_data <- dummy_data(1000)

# Call function
all_possible <- my_data |>
    summarise_plus(class      = c(year, sex),
                   values     = c(income, probability),
                   statistics = c("sum", "mean", "freq"),
                   formats    = list(sex = "sex."),
                   weight     = weight,
                   nesting    = "all",
                   na.rm      = TRUE) |>
    drop_type_vars()

}
