% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_with_style.R
\name{export_with_style}
\alias{export_with_style}
\title{Export Data Frame With Style}
\usage{
export_with_style(
  data_frame,
  titles = c(),
  footnotes = c(),
  var_labels = list(),
  workbook = NULL,
  style = excel_output_style(),
  output = "excel",
  print = TRUE,
  monitor = FALSE
)
}
\arguments{
\item{data_frame}{A data frame to print.}

\item{titles}{Specify one or more table titles.}

\item{footnotes}{Specify one or more table footnotes.}

\item{var_labels}{A list in which is specified which label should be printed for
which variable instead of the variable name.}

\item{workbook}{Insert a previously created workbook to expand the sheets instead of
creating a new file.}

\item{style}{A list of options can be passed to control the appearance of excel outputs.
Styles can be created with \code{\link[=excel_output_style]{excel_output_style()}}.}

\item{output}{The following output formats are available: excel and excel_nostyle.}

\item{print}{TRUE by default. If TRUE prints the output, if FALSE doesn't print anything. Can be used
if one only wants to catch the output workbook.}

\item{monitor}{FALSE by default. If TRUE outputs two charts to visualize the functions time consumption.}
}
\value{
Returns a formatted 'Excel' workbook.
}
\description{
\code{\link[=export_with_style]{export_with_style()}} prints a data frame as an individually styled 'Excel' table. Titles,
footnotes and labels for variable names can optionally be added.
}
\details{
\code{\link[=export_with_style]{export_with_style()}} is based on the 'SAS' procedure Proc Print, which outputs the data frame
as is into a styled table.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Define style
my_style <- excel_output_style(column_widths = c(2, 15, 15, 15, 9))

# Define titles and footnotes. If you want to add hyperlinks you can do so by
# adding "link:" followed by the hyperlink to the main text.
titles <- c("This is title number 1 link: https://cran.r-project.org/",
            "This is title number 2",
            "This is title number 3")
footnotes <- c("This is footnote number 1",
               "This is footnote number 2",
               "This is footnote number 3 link: https://cran.r-project.org/")

# Print styled data frame
my_data |> export_with_style(titles    = titles,
                             footnotes = footnotes,
                             style     = my_style)

# Retrieve formatted workbook for further usage
wb <- my_data |>
    export_with_style(titles    = titles,
                      footnotes = footnotes,
                      style     = my_style)

}
\seealso{
Creating a custom table style: \code{\link[=excel_output_style]{excel_output_style()}}, \code{\link[=modify_output_style]{modify_output_style()}},
\code{\link[=number_format_style]{number_format_style()}}, \code{\link[=modify_number_formats]{modify_number_formats()}}.

Functions that can handle styles: \code{\link[=frequencies]{frequencies()}}, \code{\link[=crosstabs]{crosstabs()}}, \code{\link[=any_table]{any_table()}}.
}
