% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aePlot.r
\name{aePlot}
\alias{aePlot}
\title{Adverse Event Plot}
\usage{
aePlot(
  formula,
  data = NULL,
  subset = NULL,
  na.action = na.retain,
  exposure = NULL,
  expunit = "",
  study = " ",
  refgroup = NULL,
  minincidence = 0,
  conf.int = 0.95,
  etype = "adverse events",
  head = NULL,
  tail = NULL,
  size = c("regular", "wide"),
  popts = NULL,
  label = NULL
)
}
\arguments{
\item{formula}{a formula with one or two left hand variables (the first representing major categorization and the second minor), and 1-2 right hand variables.  One of the right hand variables may be enclosed in \code{id()} to indicate the presence of a unique subject ID.  The remaining variable is treatment.}

\item{data}{input data frame}

\item{subset}{subsetting criteria}

\item{na.action}{function for handling \code{NA}s when creating analysis frame}

\item{exposure}{a numeric vector whose length is the number of treatments, with names equal to the treatment names}

\item{expunit}{character string specifying the time units for \code{exposure}}

\item{study}{character string identifying the study; used in multi-study reports or where distinct patient strata are analyzed separately.  Used to fetch the study-specific metadata stored by \code{\link{setqreportOption}}.  Single study reports just use \code{study=' '}.}

\item{refgroup}{a character string specifying which treatment group is subtracted when computing risk differences.  If there are two treatments the default is the first one listed in \code{qreport options}.}

\item{minincidence}{a number between 0 and 1 specifying the minimum incidence in any stratum that must hold before an event is included in the summary.  When \code{exposure} is given, \code{minincidence} applies to the hazard rate.}

\item{conf.int}{confidence level for difference in proportions (passed to \code{dotchartpl})}

\item{etype}{a character string describing the nature of the events, for example \code{"adverse events"}, \code{"serious adverse events"}.  Used in figure captions.}

\item{head}{character string.  Specifies initial text in the figure caption, otherwise a default is used.}

\item{tail}{a character string to add to end of automatic caption}

\item{size}{default is standard text body width.  Set to \code{"wide"} to render plot with \code{column: page-inset-left}.}

\item{popts}{a list of additional options to pass to \code{dotchartpl}}

\item{label}{label for figure.  \code{fig-} is placed in front of this label.  Default uses the name of the code chunk.  If a label is defined by the time the graph is produced that label will be used instead of the code chunk.}
}
\value{
no return value, called for knitting with \code{knitr}
}
\description{
Generates graphics for binary event proportions
}
\details{
Generates dot charts showing proportions of subjects having events (at any time).  Events can be categorized by a single level or by major and minor levels (e.g., body system and preferred terms).  When there are two treatments, half-width CLs of treatment differences are drawn, centered at the midpoint of the two proportions, and CLs for differences appear in hover text.   Input data must contain one record per event, with this record containing the event name.  If there is more than one event of a given type per subject, unique subject ID must be provided.  Denominators come from \code{qreport} options when computing event incidence proportions.  Instead, when a named vector \code{exposure} is specified, with names equal to the treatments, \code{exposure} is used as the denominator so that the exponential distribution hazard rate is computed, i.e., events per unit of exposure time.  When a subject has only one event of each type, the usual interpretation holds.  When a subject has multiple events, the estimate is events per person per time unit.  A character variable \code{expunit} defines the time units.   It is assumed that only randomized subjects are included in the dataset.  Whenever the number of events of a given type is zero for a group, the event frequency is changed to 0.5 so that one may compute confidence intervals on the log scale as well as hazard ratios.

For an example with output see https://hbiostat.org/rflow/descript.html#adverse-event-chart/
}
\examples{
# See test.Rnw in tests directory
}
\author{
Frank Harrell
}
