% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{qsave}
\alias{qsave}
\title{qsave}
\usage{
qsave(x, file, compress_level)
}
\arguments{
\item{x}{the object to serialize.}

\item{file}{the file name/path.}

\item{compress_level}{The compression level (-50 to 22).  Default -1.  Higher values tend to have a better compression ratio, while lower values/negative values tend to be quicker.  Values with good compression/speed tradeoffs seem to be -1, 1 and 4.}
}
\value{
The de-serialized object
}
\description{
Saves (serializes) an object to disk.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
myfile <- tempfile()
qsave(x, myfile)
x2 <- qread(myfile)
identical(x, x2) # returns true

z <- 1:1e7
myfile <- tempfile()
qsave(z, myfile)
z2 <- qread(myfile)
identical(z, z2) # returns true

w <- as.list(rnorm(1e6))
myfile <- tempfile()
qsave(w, myfile)
w2 <- qread(myfile)
identical(w, w2) # returns true
}
