#ifndef BASE85_H
#define BASE85_H

static const char base85_encoder_ring [85 + 1] = {
  "0123456789" 
  "abcdefghij" 
  "klmnopqrst" 
  "uvwxyzABCD"
  "EFGHIJKLMN" 
  "OPQRSTUVWX" 
  "YZ.-:+=^!/" 
  "*?&<>()[]{" 
  "}@%$#"
};


// the spec has many invalid characters
// We will check them within the function
// invalid:
//  < 33 (32 = space)
//  > 125 (126 = ~, 127 = DEL) ... 33 to 125 = 93 possible characters
//  Additional exclusions according to spec
//  " = 34
//  ' = 39
//  , = 44
//  ; = 59
//  \ = 92
//  _ = 95
//  ` = 96
//  | = 124
static const uint8_t base85_decoder_ring [96] = {
  0x00, 0x44, 0x00, 0x54, 0x53, 0x52, 0x48, 0x00, //  !"#$%&' 
  0x4B, 0x4C, 0x46, 0x41, 0x00, 0x3F, 0x3E, 0x45, // ()*+,-./
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, // 01234567
  0x08, 0x09, 0x40, 0x00, 0x49, 0x42, 0x4A, 0x47, // 89:;<=>?
  0x51, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, // @ABCDEFG
  0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, // HIJKLMNO
  0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, // PQRSTUVW
  0x3B, 0x3C, 0x3D, 0x4D, 0x00, 0x4E, 0x43, 0x00, // XYZ[\]^_
  0x00, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, // `abcdefg
  0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, // hijklmno
  0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, // pqrstuvw
  0x21, 0x22, 0x23, 0x4F, 0x00, 0x50, 0x00, 0x00  // xyz{|}~
};

inline void base85_check_byte(uint8_t byte) {
  if((byte < 33) | (byte > 125) | 
     (byte == 34) | (byte == 39) |( byte == 44) | (byte == 59) | (byte == 92) |
     (byte == 95) | (byte == 96) | (byte == 124)) {
    throw std::runtime_error("base85_decode: corrupted input data, invalid encoded character");
  }
}

#endif
