% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure.R
\docType{methods}
\name{measure}
\alias{measure}
\alias{measure,qstate-method}
\title{Method measure}
\usage{
measure(e1, bit = NA, repetitions = NA)

\S4method{measure}{qstate}(e1, bit = NA, repetitions = 1)
}
\arguments{
\item{e1}{object to measure}

\item{bit}{bit to project on}

\item{repetitions}{number of measurements}
}
\value{
\code{measure(e1, bit, repetitions)} returns a list with the measured \code{bit},
the number of \code{repetitions}, the probability distribution of all states
\code{prob} and the results vector \code{value}. If all bits are measured, the
basis is added to the list as \code{basis}. The collapsed state is stored as
\code{psi} if exactly one measurement is performed.
In the case of a single qubit measurement \code{value} is of length \code{repetitions}
and contains all the results of this projection. Otherwise \code{value} is of
length 2^nbits and it contains the counts how often each state has been
obtained.
}
\description{
performs a masurement on a \code{qstate} object.
}
\details{
\code{measure(e1, bit, repetitions)} performs \code{repetitions} many
projections/measurements of the qubit \code{bit}. If \code{bit} is not given
explicitly, all qubits are projected.
}
\examples{
## measure the separate bits
x <- H(1) * (H(2) * qstate(nbits=2))
summary(measure(x, bit=1))
hist(measure(x, rep=100))
}
