% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsub_config.R
\name{set_default_qsub_config}
\alias{set_default_qsub_config}
\title{Set a default qsub_config.}
\usage{
set_default_qsub_config(
  qsub_config,
  permanent = TRUE,
  config_file = config_file_location()
)
}
\arguments{
\item{qsub_config}{The qsub_config to use as default.}

\item{permanent}{Whether or not to make this the default qsub_config.}

\item{config_file}{The location to which to save the permanent qsub_config.}
}
\description{
If permanent, the qsub_config will be written to the specified path.
Otherwise, it will be saved in the current environment.
}
\examples{
\dontrun{
qsub_config <- create_qsub_config(
  remote = "myserver",
  local_tmp_path = "/home/myuser/workspace/.r2gridengine",
  remote_tmp_path = "/scratch/myuser/.r2gridengine"
)
set_default_qsub_config(qsub_config, permanent = T)
qsub_lapply(1:10, function(x) x + 1)
}

}
\seealso{
\code{\link{qsub_lapply}}, \code{\link{create_qsub_config}}
}
