% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QDiD.R
\name{QDiD}
\alias{QDiD}
\title{Quantile Difference in Differences}
\usage{
QDiD(formla, xformla = NULL, t, tmin1, tname, data, panel = FALSE,
  se = TRUE, idname = NULL, alp = 0.05, probs = seq(0.05, 0.95,
  0.05), iters = 100, retEachIter = FALSE, pl = FALSE,
  cores = NULL)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary), d should be equal to one
in all time periods for individuals that are eventually treated}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{t}{The 3rd time period in the sample.  Treated individuals should
be treated in this time period and untreated individuals should not be
treated.  The code attempts to enforce this condition, but it is good
try to handle this outside the panel.qtet method.}

\item{tmin1}{The 2nd time period in the sample.  This should be a
pre-treatment period for all individuals in the sample.}

\item{tname}{The name of the column containing the time periods}

\item{data}{A data.frame containing all the variables used}

\item{panel}{Binary variable indicating whether or not the dataset is
panel.  This is used for computing bootstrap standard errors correctly.}

\item{se}{Boolean whether or not to compute standard errors}

\item{idname}{The individual (cross-sectional unit) id name}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{retEachIter}{Boolean whether or not to return list of results
from each iteration of the bootstrap procedure (default is FALSE).
This is potentially useful for debugging but can cause errors due
to running out of memory.}

\item{pl}{Whether or not to compute standard errors in parallel}

\item{cores}{Number of cores to use if computing in parallel}
}
\value{
QTE Object
}
\description{
\code{QDiD} is a Difference in Differences type method for
computing the QTET.

The method can accommodate conditioning on covariates though it does so
in a restrictive way:  It specifies a linear model for outcomes conditional
on group-time dummies and covariates.  Then, after residualizing (see details
in Athey and Imbens (2006)), it computes the Change in Changes model
based on these quasi-residuals.
}
\examples{
## load the data
data(lalonde)

## Run the Quantile Difference in Differences method conditioning on
## age, education, black, hispanic, married, and nodegree
qd1 <- QDiD(re ~ treat, t=1978, tmin1=1975, tname="year",
 xformla=~age + I(age^2) + education + black + hispanic + married + nodegree,
 data=lalonde.psid.panel, idname="id", se=FALSE,
 probs=seq(0.05, 0.95, 0.05))
summary(qd1)

}
\references{
Athey, Susan and Guido Imbens.  ``Identification and Inference in Nonlinear
 Difference-in-Differences Models.'' Econometrica 74.2, pp. 431-497,
 2006.
}
