% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_type_metrics.R
\name{calc_type_metrics}
\alias{calc_type_metrics}
\title{Calculate Type Metrics for Text Data}
\usage{
calc_type_metrics(data, type, document, frequency = NULL, dispersion = NULL)
}
\arguments{
\item{data}{A data frame containing the tokenized text data}

\item{type}{The variable in \code{data} that contains the type
(e.g., term, lemma) to analyze.}

\item{document}{The variable in \code{data} that contains the document IDs.}

\item{frequency}{A character vector indicating which
frequency metrics to use. If NULL (default),
only the \code{type} and \code{n} are returned.
Other options:
'all',
'rf' calculates relative frequency,
'orf' calculates observed relative frequency.
Can specify multiple options: c("rf", "orf").}

\item{dispersion}{A character vector indicating which
dispersion metrics to use. If NULL (default),
only the \code{type} and \code{n} are returned.
Other options:
'all',
'df' calculates Document Frequency.
'idf' calculates Inverse Document Frequency.
'dp' calculates Gries' Deviation of Proportions.
Can specify multiple options: c("df", "idf").}
}
\value{
A data frame with columns:
\itemize{
\item \code{type}: The unique types from the input data.
\item \code{n}: The frequency of each type across all document.
Optionally (based on the \code{frequency} and \code{dispersion} arguments):
\item \code{rf}: The relative frequency of each type across all document.
\item \code{orf}: The observed relative frequency (per 100) of each
type across all document.
\item \code{df}: The document frequency of each type.
\item \code{idf}: The inverse document frequency of each type.
\item \code{dp}: Gries' Deviation of Proportions of each type.
}
}
\description{
This function calculates type metrics for tokenized text data.
}
\examples{
data_path <- system.file("extdata", "types_data.rds", package = "qtkit")
data <- readRDS(data_path)
calc_type_metrics(
  data = data,
  type = type,
  document = document,
  frequency = c("rf", "orf"),
  dispersion = c("df", "idf")
)

}
\references{
Gries, Stefan Th. (2023). Statistical Methods in Corpus Linguistics.
In Readings in Corpus Linguistics: A Teaching and Research Guide
for Scholars in Nigeria and Beyond, pp. 78-114.
}
